/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.domain;

import com.ibm.hwmca.base.pa.event.ConsoleDomainAnalysisEvent;
import com.ibm.hwmca.base.pa.event.ConsoleTimeoutEvent;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.pa.config.AnalysisDomainData;
import com.ibm.hwmca.fw.pa.config.ConsoleADData;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.AnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.AnalysisDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import java.util.HashSet;
import java.util.Set;

public class ConsoleAnalysisDomain
extends Domain
implements AnalysisDomain {
    private static final String TRACE_MASKT = "XPACNADT";
    private static final String TRACE_MASKF = "XPACNADF";
    private static final String TRACE_MASKD = "XPACNADD";
    protected static ConsoleADData cadData = null;
    protected static ProblemAnalysisEventManager evtMgr = null;
    protected int microcodeWait = 5;
    protected int hardwareWait = 5;
    private ConsoleSystem consoleSystem = null;
    public static final DomainIdentifier CAD_DOMAINID = new DomainIdentifier("Console");

    public ConsoleAnalysisDomain() {
    }

    public ConsoleAnalysisDomain(DomainIdentifier did) {
        super(did);
    }

    public Set buildDomainInstances(AnalysisDomainData adData, ProblemAnalysisEventManager evtMgr) {
        Trace.trace(TRACE_MASKD, "--> buildDomainInstances");
        cadData = (ConsoleADData)adData;
        ConsoleAnalysisDomain.evtMgr = evtMgr;
        Set instanceSet = super.buildDomainInstances();
        Trace.trace(TRACE_MASKD, "<-- buildDomainInstances");
        return instanceSet;
    }

    protected Set instantiateDomains() {
        HashSet<ConsoleAnalysisDomain> cadSet = new HashSet<ConsoleAnalysisDomain>();
        String systemClassName = cadData.getConsoleSystemClassName();
        Object systemInstance = null;
        try {
            systemInstance = Class.forName(systemClassName).newInstance();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> instantiateDomains: exception instantiating " + systemClassName);
            Trace.trace(TRACE_MASKT, e);
            return cadSet;
        }
        if (!(systemInstance instanceof ConsoleSystem)) {
            Trace.trace(TRACE_MASKT, "<-> instantiateDomains: bad XML configuration for " + cadData.getName() + " (non-ConsoleSystem)");
            return cadSet;
        }
        ConsoleAnalysisDomain cadInstance = new ConsoleAnalysisDomain(CAD_DOMAINID);
        cadInstance.setConsoleSystem(systemInstance);
        cadSet.add(cadInstance);
        return cadSet;
    }

    protected void initialize() {
        super.initialize();
        int tempVal = cadData.getTimeoutValue("MicroCodeAnalysis");
        if (tempVal != -1) {
            this.setMicrocodeWait(tempVal);
        }
        if ((tempVal = cadData.getTimeoutValue("HardwareAnalysis")) != -1) {
            this.setHardwareWait(tempVal);
        }
    }

    public ConsoleSystem getConsoleSystem() {
        return this.consoleSystem;
    }

    public void setConsoleSystem(ConsoleSystem consoleSystem) {
        this.consoleSystem = consoleSystem;
    }

    public int getMicrocodeWait() {
        return this.microcodeWait;
    }

    public void setMicrocodeWait(int waitVal) {
        this.microcodeWait = waitVal;
    }

    public int getHardwareWait() {
        return this.hardwareWait;
    }

    public void setHardwareWait(int waitVal) {
        this.hardwareWait = waitVal;
    }

    public ProblemAnalysisEventManager getEventManager() {
        return evtMgr;
    }

    public void setEventManager(ProblemAnalysisEventManager evtMgr) {
        ConsoleAnalysisDomain.evtMgr = evtMgr;
    }

    public CommonServiceAREvent getInitialTimeoutEvent(Object source) {
        return new ConsoleTimeoutEvent(source);
    }

    public AnalysisDomainAnalysisEvent getSystemAnalysisEvent(Object source) {
        return new ConsoleDomainAnalysisEvent(source);
    }

    public String getDomainReservationKey() {
        return this.getDomainId().getDID();
    }

    public String getDomainReservationKey(int problemNumber) {
        return this.getDomainReservationKey() + "_" + Integer.toString(problemNumber);
    }
}

